/*****************************************************************************
 * $Id$
 *
 * Project: 	NXP LPC11U6x IAP
 *
 * Description: Provides access to EEPROM routines
 * 			    contained within the bootROM sector of LPC11xx devices.
 *
 * Copyright(C) 2010, NXP Semiconductor
 * All rights reserved.
 *
 *****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
#include "EEPROM.h"
#include <LPC11U6x.h>

/*  Command Definitions */
#define	EEPROM_CMD_WRITE      			61
#define	EEPROM_CMD_READ	            	62


/* EEPROM boot ROM location and access function */
#define EEPROM_ROM_LOCATION				0x1FFF1FF1UL
#define EEPROM_EXECUTE_CMD(a, b)			((void (*)())(EEPROM_ROM_LOCATION))(a, b)



/*****************************************************************************
** Function name:	u32EEPROM_WRITE
**
** Description:		Program the EEPROM with data stored in RAM.
**
** Parameters:	   	u32DstAddr - Destination EEPROM address
**			 		u32SrcAddr - Source RAM address, should be a word boundary
**			 		u32Len     - Number of 8-bit bytes to write,
*
** Returned value:	Status code returned by EEPROM ROM function.
**
******************************************************************************/
uint32_t u32EEPROM_WRITE(uint32_t u32DstAddr, uint32_t u32SrcAddr, uint32_t u32Len)
{
	uint32_t au32Result[3];
	uint32_t au32Command[5];

	au32Command[0] = EEPROM_CMD_WRITE;
	au32Command[1] = u32DstAddr;
	au32Command[2] = u32SrcAddr;
	au32Command[3] = u32Len;
	au32Command[4] = SystemCoreClock / 1000UL;	/* Core clock frequency in kHz */

	__disable_irq();
	EEPROM_EXECUTE_CMD(au32Command, au32Result);
	__enable_irq();
	return au32Result[0];
}

/*****************************************************************************
** Function name:	u32EEPROM_READ
**
** Description:		Program the EEPROM with data stored in RAM.
**
** Parameters:	   	u32DstAddr - Source EEPROM address
**			 		u32SrcAddr - Destination RAM address, should be a word boundary
**			 		u32Len     - Number of 8-bit bytes to write,
*
** Returned value:	Status code returned by EEPROM ROM function.
**
******************************************************************************/
uint32_t u32EEPROM_READ(uint32_t u32SrcAddr, uint32_t u32DstAddr, uint32_t u32Len)
{
	uint32_t au32Result[3];
	uint32_t au32Command[5];

	au32Command[0] = EEPROM_CMD_READ;
	au32Command[1] = u32SrcAddr;
	au32Command[2] = u32DstAddr;
	au32Command[3] = u32Len;
	au32Command[4] = SystemCoreClock / 1000UL;	/* Core clock frequency in kHz */					   

	__disable_irq();
	EEPROM_EXECUTE_CMD(au32Command, au32Result);
	__enable_irq();
	return au32Result[0];
}




/*****************************************************************************
 **                            End Of File
 *****************************************************************************/
